/*global define, nmlImpl */
/*jslint white: true */

// define the nml module by returning an object with the exported methods exposed
define  ([  "src/build/Builder",	   "src/events/EventGraphs"],
function(   Builder,                   EventGraphs) {
	'use strict';

	var nml = {};  // the nml namespace: delegates to platform implmenetation

	nml.getCurrentTime = function () {
		return nmlImpl.getCurrentTime();
	};

	nml.newBuilder = function () {
		return new Builder();
	};

	nml.getCurrentStageId = function () {
		var stageId = nmlImpl.getCurrentStageId();
		return stageId;
	};

	nml.newStage = function (inCanvasID, inScene0) {
		var newStage = nmlImpl.newStage(inCanvasID, inScene0);
		return newStage;
	};

	nml.getStage = function (inCanvasID) {
		var stage = nmlImpl.getStage(inCanvasID);
		return stage;
	};

	nml.getEventGraph = function (id) {
		return nmlImpl.getEventGraph(id);
	};

	nml.setEventGraph = function (id, graph) {
	    nmlImpl.setEventGraph(id, graph);
	};

	nml.displayMessage = function (msg, timeF) {
	    nmlImpl.displayMessage(msg, timeF);
	};
	
	nml.translateZstring = function (zstr) {
	    return nmlImpl.translateZstring(zstr);
	};

	nml.initEventGraph = function (inId, inStage0) {
		// If inStage0 is valid, mouse/key/touch events are attached and published.
		var graphs = this.getEventGraph(inId);
		if (graphs === undefined) {
			graphs = new EventGraphs(inId, inStage0);
			this.setEventGraph(inId, graphs);
		}
		return graphs;
	};

	return nml;
});
